<?php

declare(strict_types=1);

namespace Drupal\Tests\workflows\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\workflows\Entity\Workflow;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Test a predefined workflow based on something other than configuration.
 */
#[Group('workflows')]
#[RunTestsInSeparateProcesses]
class PredefinedWorkflowTypeTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['workflows', 'workflow_type_test'];

  /**
   * Tests a predefined workflow type.
   */
  public function testPredefinedWorkflowType(): void {
    $workflow = Workflow::create([
      'id' => 'aces',
      'label' => 'Aces Workflow',
      'type' => 'predefined_states_workflow_test_type',
      'transitions' => [
        'bet' => [
          'label' => 'Bet',
          'from' => [
            'pay_blinds',
          ],
          'to' => 'bet',
        ],
        'raise' => [
          'label' => 'Raise',
          'from' => [
            'pay_blinds',
          ],
          'to' => 'raise',
        ],
      ],
    ]);
    $workflow->save();

    // No states configuration is stored for this workflow.
    $configuration = $workflow->getTypePlugin()->getConfiguration();
    $this->assertFalse(isset($configuration['states']));
  }

}
