<?php

// DO NOT EDIT, this is an Auto-generated file from script/semantic-conventions

declare(strict_types=1);

namespace OpenTelemetry\SemConv\Incubating\Attributes;

/**
 * Semantic attributes and corresponding values for user_agent.
 * @see https://opentelemetry.io/docs/specs/semconv/registry/attributes/user_agent/
 * May contain @experimental Semantic Conventions which may change or be removed in the future.
 */
interface UserAgentIncubatingAttributes
{
    /**
     * Name of the user-agent extracted from original. Usually refers to the browser's name.
     *
     * [Example](https://www.whatsmyua.info) of extracting browser's name from original string. In the case of using a user-agent for non-browser products, such as microservices with multiple names/versions inside the `user_agent.original`, the most significant name SHOULD be selected. In such a scenario it should align with `user_agent.version`
     *
     * @experimental
     */
    public const USER_AGENT_NAME = 'user_agent.name';

    /**
     * Value of the [HTTP User-Agent](https://www.rfc-editor.org/rfc/rfc9110.html#field.user-agent) header sent by the client.
     *
     * @stable
     */
    public const USER_AGENT_ORIGINAL = 'user_agent.original';

    /**
     * Human readable operating system name.
     * For mapping user agent strings to OS names, libraries such as [ua-parser](https://github.com/ua-parser) can be utilized.
     *
     * @experimental
     */
    public const USER_AGENT_OS_NAME = 'user_agent.os.name';

    /**
     * The version string of the operating system as defined in [Version Attributes](/docs/resource/README.md#version-attributes).
     *
     * For mapping user agent strings to OS versions, libraries such as [ua-parser](https://github.com/ua-parser) can be utilized.
     *
     * @experimental
     */
    public const USER_AGENT_OS_VERSION = 'user_agent.os.version';

    /**
     * Specifies the category of synthetic traffic, such as tests or bots.
     *
     * This attribute MAY be derived from the contents of the `user_agent.original` attribute. Components that populate the attribute are responsible for determining what they consider to be synthetic bot or test traffic. This attribute can either be set for self-identification purposes, or on telemetry detected to be generated as a result of a synthetic request. This attribute is useful for distinguishing between genuine client traffic and synthetic traffic generated by bots or tests.
     *
     * @experimental
     */
    public const USER_AGENT_SYNTHETIC_TYPE = 'user_agent.synthetic.type';

    /**
     * Bot source.
     * @experimental
     */
    public const USER_AGENT_SYNTHETIC_TYPE_VALUE_BOT = 'bot';

    /**
     * Synthetic test source.
     * @experimental
     */
    public const USER_AGENT_SYNTHETIC_TYPE_VALUE_TEST = 'test';

    /**
     * Version of the user-agent extracted from original. Usually refers to the browser's version
     *
     * [Example](https://www.whatsmyua.info) of extracting browser's version from original string. In the case of using a user-agent for non-browser products, such as microservices with multiple names/versions inside the `user_agent.original`, the most significant version SHOULD be selected. In such a scenario it should align with `user_agent.name`
     *
     * @experimental
     */
    public const USER_AGENT_VERSION = 'user_agent.version';

}
