<?php

namespace Drupal\drupal_admin_app\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Drupal Admin App settings.
 */
class AdminConfigForm extends ConfigFormBase {

  /**
   * Config settings.
   *
   * @var string
   */
  const SETTINGS = 'drupal_admin_app.settings';

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'drupal_admin_app_admin_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      static::SETTINGS,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config(static::SETTINGS);

    $form['log_limit'] = [
      '#type' => 'number',
      '#title' => $this->t('Log Entries Limit'),
      '#description' => $this->t('Maximum number of log entries to return via the API. Default is 20.'),
      '#default_value' => $config->get('log_limit') ?: 20,
      '#min' => 1,
      '#max' => 1000,
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config(static::SETTINGS)
      ->set('log_limit', $form_state->getValue('log_limit'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
