# Ethics and Accessibility Readings

This curated list supports responsible use of AI in editorial workflows.

## Accessibility

- Web Content Accessibility Guidelines (WCAG)  
  https://www.w3.org/WAI/standards-guidelines/wcag/
- Accessibility fundamentals for web editors  
  https://www.w3.org/WAI/fundamentals/accessibility-intro/

Readability guidance:
- Plain language checklist  
  https://www.plainlanguage.gov/guidelines/

## Bias and Representation

- Understanding bias in machine learning  
  https://developers.google.com/machine-learning/fairness-overview
- Practical tips to detect representational harm  
  https://www.partnershiponai.org/

## Editorial Governance

- Drupal role-based permissions  
  `/admin/people/permissions`
- Drafts and workflow states help keep humans in the loop

---

## Workshop Key Principles

- AI can draft. **Humans decide.**
- Accessibility cannot regress due to automation.
- Bias must be **identified**, **corrected**, and **escalated** if unclear.
- Separate fields or drafts allow controlled human review.
- Editorial governance is a **process**, not a checkbox.

