# Session 6 — Wrap-Up and Next Steps

Copyright © 2025 James Matthew Saunders and Rod Martin.
Created with support from amazee.io and Promet Source.
Licensed under Creative Commons Attribution–ShareAlike 4.0 International (CC BY-SA 4.0).

Audience: Beginning Drupal users  
Admin theme: Gin  
Environment: Drupal.org AI Demo environment (Drupal AI Demo)

---

## What you accomplished

- Launched the **Drupal AI Demo** using **Advanced Drupal Skills**
- Verified an AI provider responds
- Used CKEditor AI to summarise and adjust tone
- Enabled AI tools in a text format and set safe defaults
- Applied a **Tone** vocabulary to give editors controlled voice options
- Turned on **Content Suggestions** (Readability, Summarise Text, Suggest Title)
- Understood how **Automators** and **Recipes** fit (conceptual, demo-available path)
- Practised responsible review for bias, accuracy, and accessibility

---

## Quick self-check (2 minutes)

- [ ] I can find **AI Providers** and test a connection (`/admin/config/ai/providers`)
- [ ] I know where **AI Settings** live and why temperature matters
- [ ] CKEditor **AI buttons** appear in my text format
- [ ] **Tone** terms show up in the Tone menu
- [ ] I can keep changes in **draft** and restrict AI permissions by role
- [ ] I understand what **Automators** and **Recipes** are for

If any box is unchecked, note it now and review the matching session before moving on.

---

## Next steps on your own site

1. **Decide governance**  
   - Who can use AI features?  
   - Where do AI outputs live (separate fields, drafts)?  
   - What review is required before publish?

2. **Standardise tone**  
   - Finalise Tone vocabulary and descriptions  
   - Add examples so editors know what “good” looks like

3. **Harden text formats**  
   - Keep only the AI buttons you intend to teach  
   - Define consistent defaults in **AI Settings**

4. **Plan for Automators/Recipes**  
   - Identify 1–2 high-value tasks (eg. Simplified Title, Plain-language body)  
   - Start with low-temperature, predictable outputs  
   - Attach to non-destructive fields first

5. **Train, then scale**  
   - Run a pilot with a small editorial group  
   - Capture feedback and refine prompts/recipes  
   - Roll out gradually with documentation

---

## Where to go deeper

- **Resources → Modules and Providers**  
  Capabilities, bridges, and practical notes

- **Resources → Videos and Demos**  
  Short walkthroughs you can replay

- **Resources → Ethics and Accessibility Readings**  
  Bias detection, WCAG alignment, practical editorial checklists

> Tip: keep a living **Editorial AI Guide** in your intranet. Link to this curriculum and your own site’s rules.

---

## Appendix (optional paths after the demo)

- **Local install:** Drupal CMS with AI modules configured
- **DDEV recipe:** for repeatable workshop machines
- **DrupalPod:** zero-install browser-based option

Choose one path and document it for your team.

---

## Attribution and licence

Copyright © 2025 James Matthew Saunders and Rod Martin.  
Created with support from amazee.io and Promet Source.  
Licensed under Creative Commons Attribution–ShareAlike 4.0 International (CC BY-SA 4.0).
