<?php

declare(strict_types=1);

namespace Drupal\Tests\drupal_association_extras\Functional;

use Behat\Mink\Element\NodeElement;
use Drupal\Tests\BrowserTestBase;
use PHPUnit\Framework\Attributes\CoversFunction;
use PHPUnit\Framework\Attributes\Group;

#[Group('drupal_association_extras')]
#[CoversFunction('drupal_association_extras_install')]
final class LaunchLinkTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['drupal_association_extras'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  public function testLaunchLinkIsAddedToNavigationFooter(): void {
    $account = $this->createUser(['access navigation']);
    $this->drupalLogin($account);

    // Get all the top-level navigation items.
    $navigation_items = array_map(
      fn (NodeElement $item): string => $item->getText(),
      $this->getSession()->getPage()->findAll('css', '.toolbar-block__list > li > a'),
    );
    $this->assertSame('🚀 Ready to launch?', end($navigation_items));
  }

}
