# Drupal CMS Geo Images

## Automatically import and Geo Map all your images and photo shoots in Drupal!

Drupal Recipe for [Drupal CMS](https://new.drupal.org/drupal-cms) (& Drupal 10+)
that implements advanced Geo Mapping functionalities with Media Images.

## Introduction
This Drupal Recipe enhances Drupal (10+) with advanced Geo Mapping
functionalities with Media Geo Images provided with EXIF data, regarding both
Shoot Location/Coordinates and Shoot Creation Date.

It is based on the advanced application and configuration of the Geofield and
Drupal Media modules stacks, and is developed and tested on DrupalCMS (11+) and
in particular on its following basic variants:
- Core (no recipe and pre-configuration type applied)
- Events (recipe / pre-configuration type applied)

Notwithstanding the above it may work fine and apply to any other Drupal
instance where there are no existing configuration conflicts.

**Requirements and Dependencies**
Please check the following files for required dependencies:
- [composer.json (require section)](https://git.drupalcode.org/project/drupal_cms_geo_images/-/blob/1.1.x/composer.json?ref_type=heads)\
- [recipe.yml (install section)](https://git.drupalcode.org/project/drupal_cms_geo_images/-/blob/1.1.x/recipe.yml?ref_type=heads#L4)

## Instructions
### How to require / install it and make it magically work (out of the box)

This Drupal Recipe enhances the advanced interaction between the
[Geofield](https://www.drupal.org/project/geofield), [Leaflet](https://www.drupal.org/project/leaflet)
& [Geocoder](https://www.drupal.org/project/geocoder)
geo mapping modules and the
[Media Library Importer](https://www.drupal.org/project/media_library_importer)
module, for the automatic import of your images and photo shoots.

**Note: This Drupal Recipe Instructions assume the use of [DDEV](https://github.com/ddev/ddev)**


### Step 1: place your images ready for import
The Drupal Recipe "out of the box" configuration expects to find all you images
in (and import from) the following "photo_albums" folder:

```/web/sites/default/files/photo_albums```

and is going to import all the images into geo images media from there.

**Thus please place the images you want to import and automatically geomap in
that folder** of your Drupal (CMS & 10+) instance.

**Warm Tip**: As a first test and import it is much better not to exceed a
number of images above 50 - 100, in order not to experience a too long
operating process. You will always be able to perform incremental / additional
imports by adding new images to the same folder, without generating duplicate
imports and Geo Images (thanks to the capabilities of the Media Library
Importer module).

### Step 2: require and install the Drupal Recipe
Apply the following composer commands:
- Require the Drupal Recipe:\
```ddev composer require drupal/drupal_cms_geo_images```
- Clear the Drupal cache:\
```ddev drush cr```
- Install and Apply the Drupal Recipe:\
``` ddev drupal recipe ../recipes/drupal_cms_geo_images```

As a result your Drupal instance should have the following:
- a new empty "Map" Home page (```/geo-images-map```) and Main Menù link;
- a new empty "Images" grid page (```/geo-images```) and Main Menù link;

### Step 3: import & automatic Geo Map your Images
Make double sure you placed your images in the "photo_albums" as instructed in
Step 1, or in any other location, changing the Media Library Importer
configuration (```/admin/config/media/media-library-importer```).

Then perform the Media Import operation, either manually from this Admin page:
```/admin/config/media/media-library-importer/import```
or throughout the following commands (worth a pre cache cleaning this time also):

```ddev drush cr && ddev drush mli```

and wait for the QueueWorkers complete all  the import and the automatic Geo
Mapping ...

**All in one shot**\
For your convenience here is a unique line command that would perform all the
above steps in one shot:\
```ddev composer require drupal/drupal_cms_geo_images && ddev drush cr && ddev drupal recipe ../recipes/drupal_cms_geo_images && ddev drush cr && ddev drush mli```

### Et Voilà! ...
You should now have:
- a new "Map" Home page (```/geo-images-map```) with your Goe Images displayed
correctly, with preview icons and marker clusters;
- a new "Images" grid page (```/geo-images```) with your images properly displayed,
sorted and interactively filterable by date;

## Additional hints and tech notes
The Drupal Recipe:
- implements / requires the
[itamair/geo_images_custom](https://packagist.org/packages/itamair/geo_images_custom) custom
Drupal module (located in packagist) to enhance specific functional logics.
Feel free to check it out!
- also generates a Geometry content type, with additional parametric fields &
attributes (such Stroke Color, Stroke Width, Fill Color, etc.) and Leaflet
Formatter & Leaflet View Style token and Replacement Patterns
presets, by which to enhance and investigate advanced Geo Mapping Drupal
capabilities.
- implements automatic links to Google Maps and Streetview pages of your Geo
Images, throughout the
[pschocke/google-maps-links](https://packagist.org/packages/pschocke/google-maps-links) php library;
- etc ...

Enjoy automatic Geo Mapping of your Photos and your Geographic Story telling
in Drupal.

### Authors/Credits
- Italo Mairo - [itamair](https://www.drupal.org/u/itamair) (creator and maintainer)
