<?php

declare(strict_types=1);

namespace Drupal\drupal_cms_helper\EventSubscriber;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\EventSubscriber\HttpExceptionSubscriberBase;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Routing\RedirectDestinationInterface;
use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpKernel\Event\ExceptionEvent;

/**
 * @internal
 *   This is an internal part of Drupal CMS and may be changed or removed at any
 *   time without warning. External code should not interact with this class.
 *
 * @todo Remove this either when https://www.drupal.org/i/3508338 is released,
 *   or when Gin has been moved into core and https://www.drupal.org/i/3554693
 *   has been released.
 */
final class AccessDeniedSubscriber extends HttpExceptionSubscriberBase {

  public function __construct(
    private readonly ModuleHandlerInterface $moduleHandler,
    private readonly ConfigFactoryInterface $configFactory,
    private readonly RedirectDestinationInterface $redirect,
  ) {}

  /**
   * {@inheritdoc}
   */
  protected function getHandledFormats(): array {
    return ['html'];
  }

  /**
   * {@inheritdoc}
   */
  protected static function getPriority(): int {
    // Run before the User module's exception subscriber.
    return 100;
  }

  protected function on403(ExceptionEvent $event): void {
    // If all 403s should redirect to the login page, work around
    // https://www.drupal.org/i/3508338 by doing a full redirect.
    if ($this->moduleHandler->moduleExists('gin_login') && $this->configFactory->get('system.site')->get('page.403') === '/user/login') {
      $url = Url::fromRoute('user.login')
        ->setOption('query', $this->redirect->getAsArray())
        ->toString();
      $event->setResponse(new RedirectResponse($url));
    }
  }

}
