<?php

declare(strict_types=1);

namespace Drupal\Tests\drupal_cms_helper\Functional;
use Drupal\Core\Extension\ThemeInstallerInterface;
use Drupal\Tests\BrowserTestBase;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

#[Group('drupal_cms_helper')]
#[RunTestsInSeparateProcesses]
final class LoginThemeTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'drupal_cms_helper',
    'gin_login',
  ];

  public function testLoginPageThemeOn403(): void {
    $this->container->get(ThemeInstallerInterface::class)->install(['gin']);
    $this->config('system.site')->set('page.403', '/user/login')->save();
    $this->config('system.theme')->set('admin', 'gin')->save();

    $this->drupalGet('/admin');
    $assert_session = $this->assertSession();
    // We were fully redirected, so it's a 200 instead of a 403.
    $assert_session->statusCodeEquals(200);
    $this->assertStringContainsString('/user/login?destination=', $this->getUrl());
    // Gin should be the active theme; we can detect that since it will have
    // injected JS settings.
    $this->assertArrayHasKey('gin', $this->getDrupalSettings());
  }

}
