This is a starter kit for creating a Drupal CMS-based site template. The idea is to customize it into a fantastic site template using Drupal CMS's basic feature set, plus your own additions.

To use it, you'll:

* Copy this project into your own repository
* Follow the instructions below to set up a working Drupal site
* Make changes to that site (via the UI, Drush, or any other way)
* Use Drush to export the changes back into your repository
* Publish your repository

Now others will be able to pull that repository and use it spin up a Drupal site exactly like the one you exported.

## Getting Started

**Prerequisites**: [DDEV](https://ddev.com) 1.24.0 or later. DDEV is Drupal CMS's Docker-based local development environment of choice; you don't _have_ to use it, but we strongly recommend it because it provides everything you need and configures it for you. These instructions will assume you have DDEV [installed](https://docs.ddev.com/en/stable).

First, spin up a new Drupal CMS project:

```shell
mkdir cms
cd cms
ddev config --project-type=drupal11 --docroot=web
ddev start
ddev composer create-project drupal/cms:^2 --stability=alpha --no-install
ddev composer config minimum-stability dev
ddev composer install
```

Add this starter kit to your project:

```shell
ddev composer require drupal/drupal_cms_site_template_base:1.x-dev@dev
```

Install Drupal using the starter kit:

```shell
# To install in the UI:
ddev launch

# Or at the command line with Drush:
ddev drush site:install --yes ../recipes/drupal_cms_site_template_base
ddev launch $(ddev drush user:login)
```

You're now ready to build your Drupal site however you like! When you're happy with it, you can export it into the site template:

```shell
ddev drush site:export --destination=../recipes/drupal_cms_site_template_base
```

Be sure to replace `screenshot.webp` with a screenshot of your site template. (It must have the file name `screenshot.webp` and be in WebP format.) The site template is now ready to be released!

You can, of course, make any changes you like; afterwards, use `drush site:export`, as described above, to export everything again. Bear in mind that site templates are starting points and don't support upgrade paths, so any changes you make will _not_ affect any sites in the wild that were spun up from your site template.

## No-Nos

You have a tremendous amount of freedom in how you build your site template and how it looks, but there are a few ironclad rules you need to follow:

- In `recipe.yml`, the `type` field must be `Site` (case sensitive).
- In `composer.json`, the `type` field must be `drupal-recipe`.
- Site templates **cannot** patch dependencies in any way (e.g., with the `cweagans/composer-patches` plugin). Patching dependencies can introduce maintenance problems for end users that require significant technical skills to fix.
- A site template **cannot** depend on any particular install profile. It can do light integration with certain install profiles if it so chooses (and indeed, [Recipe Installer Kit](https://www.drupal.org/project/recipe_installer_kit) takes advantage of this), but it cannot _depend_ on them.
- If you're publishing your site template on Drupal.org (or not, but _especially_ if you are), don't prefix its name with `drupal_cms_` or `drupal-cms-`. This is because, although your site template may be built _on top of_ Drupal CMS, it is not _part of_ Drupal CMS. We want to avoid creating confusion around which packages are part of Drupal CMS.
- Site templates **cannot** pin to specific versions of their dependencies (e.g., `"drupal/token": "1.13"`), because it can cause consumers of the site template to get stuck on outdated or insecure dependencies.

## Resources
* [The complete list of Drupal CMS recipes](https://www.drupal.org/project/cms#recipes): You can use any of these in your site template, to provide basic configuration and/or content types. It's recommended, but not required.
* [RFC: The architecture and philosophy of site templates](https://www.drupal.org/i/3534752): Specifies the guiding principles and limitations of site templates, in quasi-technical (but mostly informal) language.
* [Recipes Initiative documentation](https://project.pages.drupalcode.org/distributions_recipes): The technical documentation for the recipe system, how to use it, its syntax, and available config actions.
* [Recipes: It's About Time](https://www.youtube.com/watch?v=mDikN0bxcpY&list=PLpeDXSh4nHjSb2nYlToJvaD84PKoouf7c&index=31): Recorded at DrupalCon Nara 2025, this is a very clear and thorough explainer on the basics of recipes.
* The [`#recipes`](https://drupal.slack.com/archives/C2THUBAVA) and [`#drupal-cms-templates`](https://drupal.slack.com/archives/C08KVJKPUBS) channels on [Drupal Slack](https://www.drupal.org/join-slack) can be very helpful if you're stuck or have questions.

## Glossary
So we're clear on terminology:

site template
: A recipe that, when applied, sets up a nearly ready-to-launch Drupal site, including all relevant functionality, default content, and a theme. Site templates are meant to be applied at the beginning of a project, then disposed of.

recipe
: A type of Drupal extension which automates site building tasks. Recipes are declarative, disposable, and "applied" to a Drupal site, rather than installed. They contain no code and do not support updates. A site template is a type of recipe.
