# Drupal Content Repository

A Drupal 11 module that provides REST-like endpoints for accessing and rendering Drupal content entities and Single Directory Components (SDCs).

## Features

- Render individual entities on standalone pages without Drupal theming
- Render SDCs with props passed via query parameters
- Support for view modes, language selection, and access control
- Clean HTML output with only necessary CSS/JS includes

## Requirements

- Drupal 11
- Twig Tweak module

## Installation

1. Place this module in your `modules/custom` directory
2. Enable the Twig Tweak module if not already enabled
3. Enable the Drupal Content Repository module

## Usage

### Entity Rendering

Access entities using the following URL pattern:
```
/repository/{entity_type}/{id}/{view_mode}/{language}/{check_access}
```

**Parameters:**
- `entity_type` (required): Machine name of the entity type (e.g., 'node', 'paragraph', 'block', 'user', 'media')
- `id` (required): The ID of the specific entity to render
- `view_mode` (optional): View mode machine name (e.g., 'teaser', 'full', 'compact')
- `language` (optional): Language code (e.g., 'en', 'es')
- `check_access` (optional): Boolean value ('true'/'false') for access checking (defaults to 'true')

**Examples:**
- `/repository/node/123` - Render node 123 with default settings
- `/repository/node/123/teaser` - Render node 123 in teaser view mode
- `/repository/node/123/full/es/false` - Render node 123 in full view mode, Spanish language, without access checking

**Special Cases:**
- User entities always return "User info unavailable" for privacy/security
- Non-existent entities display appropriate "not found" messages with CSS classes for styling

### SDC Rendering

Access SDCs using the following URL pattern:
```
/sdc/{theme}/{sdc_name}/?prop1=value1&prop2=value2
```

**Parameters:**
- `theme` (required): The theme containing the SDC
- `sdc_name` (required): The name of the SDC to render
- Query parameters are passed as props to the SDC

**Slot Support:**
Slots can be passed using numbered parameters prefixed with 's':
```
/sdc/mytheme/mycomponent/?prop1=hello&s1=slot_content&s2=more_slot_content
```

**Examples:**
- `/sdc/olivero/card/?title=Hello&content=World` - Render card SDC with title and content props
- `/sdc/mytheme/banner/?text=Welcome&s1=<p>Slot content</p>` - Render banner with prop and slot

## Output

Both endpoints generate complete HTML documents with:
- Proper DOCTYPE and meta tags
- Required CSS and JavaScript includes from Drupal
- Minimal styling (no margin/padding on body)
- Clean, unstyled content starting from upper-left corner

## Error Handling

The module provides user-friendly error messages for:
- Entity not found scenarios
- User privacy protection
- SDC rendering failures

Error messages are wrapped in CSS classes for easy styling or hiding:
- `.entity-unavailable` - General entity not found
- `.user-unavailable` - User entity access denied
- `.sdc-unavailable` - SDC not found

## Technical Details

The module uses Twig Tweak's `drupal_entity()` function for entity rendering and follows Drupal 11's SDC rendering patterns. All parameters from the URL are passed directly to these functions, maintaining consistency with existing Drupal rendering systems.

## License

GPL-2.0-or-later