<?php

namespace Drupal\drupal_content_repository\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;

/**
 * Controller for rendering SDCs (Single Directory Components) via repository endpoints.
 */
class DrupalContentRepositorySdcController extends ControllerBase {

  /**
   * Renders an SDC using the specified parameters and query string props.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The current request object.
   * @param string $theme
   *   The theme containing the SDC.
   * @param string $sdc_name
   *   The name of the SDC to render.
   *
   * @return array
   *   A render array.
   */
  public function renderSdc(Request $request, $theme, $sdc_name) {
    // Get all query parameters as props
    $props = $request->query->all();
    
    // Process slots if any query parameters start with 's' followed by a number
    $slots = [];
    $regular_props = [];
    
    foreach ($props as $key => $value) {
      if (preg_match('/^s(\d+)$/', $key, $matches)) {
        // This is a slot parameter
        $slot_number = $matches[1];
        $slots[$slot_number] = $value;
      } else {
        // Regular prop
        $regular_props[$key] = $value;
      }
    }

    return [
      '#theme' => 'drupal_content_repository_sdc',
      '#theme_name' => $theme,
      '#sdc_name' => $sdc_name,
      '#props' => $regular_props,
      '#slots' => $slots,
    ];
  }

}