<?php

namespace Drupal\drupal_content_repository\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configuration form for Drupal Content Repository module.
 */
class DrupalContentRepositoryConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['drupal_content_repository.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'drupal_content_repository_config_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('drupal_content_repository.settings');

    $form['check_node_published'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Check node published status'),
      '#description' => $this->t('When enabled, only published nodes will be displayed. Unpublished nodes will show "Node not found" message.'),
      '#default_value' => $config->get('check_node_published') ?? FALSE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('drupal_content_repository.settings')
      ->set('check_node_published', $form_state->getValue('check_node_published'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}