/**
 * @file
 * Provides the behavior for switching product tabs.
 *
 * - Attaches a click handler to elements with the 'product-tab-link' class.
 * - Prevents the default link action.
 * - Displays the corresponding tab content using the link's data-target attribute.
 * - Hides all other tab content sections.
 * - Updates the 'active' class to highlight the selected tab link.
 */
(function ($, Drupal) {
  Drupal.behaviors.productTabs = {
    attach: function (context, settings) {
      $(document).on('click', '.product-tab-link', function (e) {
        e.preventDefault();
        const target = $(this).data('target');
        $('.product-tabs-content > div').hide();
        $('#' + target + '-tab').show();
        $('.product-tab-link').removeClass('active');
        $(this).addClass('active');
      });
    }
  };
})(jQuery, Drupal);
