(function (Drupal, once) {
  Drupal.behaviors.accessibleOffCanvas = {
    attach(context) {

      // Add aria-label to off-canvas close button for accessibility.
      const anchor = document.querySelector('main');
      if (!anchor) return;

      const observer = new MutationObserver(() => {
        const buttons = once('dialog-accessibility', '.ui-dialog-titlebar-close', document);
        if (buttons.length) {
          buttons.forEach(button => {
            button.setAttribute('aria-label', Drupal.t('Close'));
          });
          observer.disconnect();
        }
      });

      observer.observe(document.body, {
        childList: true,
        subtree: true
      });

      // Close off-canvas on body click (outside dialog).
      document.body.addEventListener('click', function (e) {
        const $dialog = document.querySelector('.ui-dialog');
        if ($dialog) {
          const insideDialog = $dialog.contains(e.target);
          const trigger = e.target.closest('.use-ajax');
          if (!insideDialog && !trigger) {
            const closeButton = $dialog.querySelector('.ui-dialog-titlebar-close');
            if (closeButton) {
              closeButton.click();
            }
          }
        }
      });
    }
  };
})(Drupal, once);
