(function (Drupal, once) {
  Drupal.behaviors.clearSearchInput = {
    attach(context) {
      const input = once('clear-search-init', '#edit-keywords', context)[0];
      if (!input) return;

      // Ensure the wrapper has relative positioning.
      const wrapper = document.createElement('div');
      wrapper.classList.add('search-input-wrapper');
      wrapper.style.position = 'relative';

      // Move input into wrapper.
      input.parentNode.insertBefore(wrapper, input);
      wrapper.appendChild(input);

      // Create the clear (X) button.
      const clearButton = document.createElement('button');
      clearButton.setAttribute('type', 'button');
      clearButton.setAttribute('aria-label', 'Remove search string');
      clearButton.setAttribute('title', 'Remove search string');
      clearButton.innerHTML = '&times;';
      clearButton.classList.add('clear-button');
      clearButton.style.cssText = `
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        background: #DADADA;
        border: none;
        font-size: 1.2rem;
        line-height: 1;
        color: #fff;
        cursor: pointer;
        display: none;
        border-radius: 50%;
      `;

      wrapper.appendChild(clearButton);

      // Toggle button visibility on input.
      input.addEventListener('input', () => {
        clearButton.style.display = input.value ? 'block' : 'none';
      });

      // Clear input on button click.
      clearButton.addEventListener('click', () => {
        input.value = '';
        clearButton.style.display = 'none';
        input.focus();
      });

      // If input has pre-filled value (e.g., after form submit), show the button.
      if (input.value) {
        clearButton.style.display = 'block';
      }
    }
  };
})(Drupal, once);
