<?php

namespace Drupal\purview_unified_catalog_ui\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configuration form for Unified Catalog settings.
 */
class UnifiedCatalogSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['purview_unified_catalog_ui.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'purview_unified_catalog_ui_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('purview_unified_catalog_ui.settings');

    // General.
    $form['general'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('General settings'),
    ];

    $form['general']['display_search_forms'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Display search forms automatically'),
      '#default_value' => $config->get('display_search_forms') ?? 1,
      '#description' => $this->t('Enable this to have search forms display automatically on term and product listing pages. Disable to place the search forms yourself (ex. in block layout).'),
    ];

    $form['general']['attribute_filter_label'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Attribute filter label'),
      '#description' => $this->t('Customize the attribute filter label on both the data products and glossary term search forms.'),
      '#default_value' => $config->get('attribute_filter_label') ?: '',
    ];

    $form['general']['attribute_filter'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Filter attributes'),
      '#description' => $this->t('Custom attributes can be used to filter against data products and glossary terms across domains. They are a great way to categorize your data. Restrict the attributes used in the attribute filters by adding one group and field per line, in the format group|field. If you leave blank all attributes will be available.'),
      '#default_value' => $config->get('attribute_filter') ?: '',
    ];

    // Governance domains.
    $form['domains'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Governance domains'),
    ];

    $form['domains']['governance_panel_default'] = [
      '#type' => 'text_format',
      '#title' => $this->t('Governance domain right panel default content'),
      '#description' => $this->t('This content will appear by default in the right-side panel on the governance domain listing page before a domain is selected.'),
      '#format' => $config->get('governance_panel_default.format') ?: 'basic_html',
      '#default_value' => $config->get('governance_panel_default.value') ?: '',
    ];

    // Data products.
    $form['products'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Data products'),
    ];

    $form['products']['filter_domain_product'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable domain filter'),
      '#default_value' => $config->get('filter_domain_product') ?? 1,
      '#description' => $this->t('Enable this to provide the ability to filter by Domain.'),
    ];

    $form['products']['filter_owner_product'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable owner filter'),
      '#default_value' => $config->get('filter_owner_product') ?? 1,
      '#description' => $this->t('Enable this to provide the ability to filter by Owner.'),
    ];

    $form['products']['filter_attributes_product'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable attribute filter'),
      '#default_value' => $config->get('filter_attributes_product') ?? 1,
      '#description' => $this->t('Enable this to provide the ability to filter by Attribute.'),
    ];

    $form['products']['products_intro'] = [
      '#type' => 'text_format',
      '#title' => $this->t('Data products intro text'),
      '#description' => $this->t('This content will appear at the top of the Data Products listing page.'),
      '#format' => $config->get('products_intro.format') ?: 'basic_html',
      '#default_value' => $config->get('products_intro.value') ?: '',
    ];

    $form['products']['data_asset_exclude'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Exclude data asset type'),
      '#description' => $this->t('Enter a comma separated list of data asset types to exclude from display. If left empty, all data assets will be displayed.'),
      '#default_value' => $config->get('data_asset_exclude') ?: '',
    ];

    $form['products']['data_asset_mapping'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Label mapping for asset type'),
      '#description' => $this->t('Enter a label mapping, one per line. For example: powerbi_dataset|PowerBI dataset'),
      '#default_value' => $config->get('data_asset_mapping') ?: '',
    ];

    $form['products']['data_assets_description'] = [
      '#type' => 'text_format',
      '#title' => $this->t('Data assets introduction'),
      '#description' => $this->t('This content will appear by default above the data asset list on the data products metadata displays (off-canvas as page).'),
      '#format' => $config->get('data_assets_description.format') ?: 'basic_html',
      '#default_value' => $config->get('data_assets_description.value') ?: '',
    ];

    // Enterprise glossary.
    $form['glossary'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Enterprise glossary'),
    ];

    $form['glossary']['filter_domain'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable domain filter'),
      '#default_value' => $config->get('filter_domain') ?? 1,
      '#description' => $this->t('Enable this to provide the ability to filter by Domain.'),
    ];

    $form['glossary']['filter_owner'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable owner filter'),
      '#default_value' => $config->get('filter_owner') ?? 1,
      '#description' => $this->t('Enable this to provide the ability to filter by Owner.'),
    ];

    $form['glossary']['filter_attributes'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable attribute filter'),
      '#default_value' => $config->get('filter_attributes') ?? 1,
      '#description' => $this->t('Enable this to provide the ability to filter by Attribute.'),
    ];

    $form['glossary']['glossary_intro'] = [
      '#type' => 'text_format',
      '#title' => $this->t('Glossary terms intro text'),
      '#description' => $this->t('This content will appear at the top of the Enterprise Glossary listing page.'),
      '#format' => $config->get('glossary_intro.format') ?: 'basic_html',
      '#default_value' => $config->get('glossary_intro.value') ?: '',
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('purview_unified_catalog_ui.settings')
      ->set('display_search_forms', $form_state->getValue('display_search_forms'))
      ->set('attribute_filter_label', $form_state->getValue('attribute_filter_label'))
      ->set('attribute_filter', $form_state->getValue('attribute_filter'))
      ->set('governance_panel_default', $form_state->getValue('governance_panel_default'))
      ->set('filter_domain_product', $form_state->getValue('filter_domain_product'))
      ->set('filter_owner_product', $form_state->getValue('filter_owner_product'))
      ->set('filter_attributes_product', $form_state->getValue('filter_attributes_product'))
      ->set('products_intro', $form_state->getValue('products_intro'))
      ->set('data_asset_exclude', $form_state->getValue('data_asset_exclude'))
      ->set('data_asset_mapping', $form_state->getValue('data_asset_mapping'))
      ->set('data_assets_description', $form_state->getValue('data_assets_description'))
      ->set('filter_domain', $form_state->getValue('filter_domain'))
      ->set('filter_owner', $form_state->getValue('filter_owner'))
      ->set('glossary_intro', $form_state->getValue('glossary_intro'))
      ->set('filter_attributes', $form_state->getValue('filter_attributes'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
