<?php

namespace Drupal\purview_unified_catalog_ui\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Form\FormBuilderInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\drupal_purview\Service\PurviewGovernanceDomainApiClient;

/**
 * Provides a "Glossary Search" block.
 *
 * @Block(
 *   id = "unified_product_search_block",
 *   admin_label = @Translation("Purview Unified Catalog Product Search")
 * )
 */
class UnifiedProductSearchBlock extends BlockBase implements ContainerFactoryPluginInterface {

  /**
   * The Purview governance domain API client.
   *
   * @var \Drupal\drupal_purview\Service\PurviewGovernanceDomainApiClient
   */
  protected PurviewGovernanceDomainApiClient $apiClient;

  /**
   * The form builder.
   *
   * @var \Drupal\Core\Form\FormBuilderInterface
   */
  protected FormBuilderInterface $formBuilder;

  /**
   * Constructs a new UnifiedProductSearchBlock instance.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    PurviewGovernanceDomainApiClient $apiClient,
    FormBuilderInterface $formBuilder,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->apiClient = $apiClient;
    $this->formBuilder = $formBuilder;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('drupal_purview.governance_domain_api'),
      $container->get('form_builder')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function build(): array {
    return $this->formBuilder->getForm('Drupal\purview_unified_catalog_ui\Form\UnifiedProductSearchForm');
  }

}
