<?php

declare(strict_types=1);

namespace Drupal\drupal_purview\Testing;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Handler\MockHandler;
use GuzzleHttp\HandlerStack;

/**
 * Builds a Guzzle client backed by a MockHandler for deterministic tests.
 *
 * @internal Test-only utility.
 */
final class HttpClientFactory {

  /**
   * Creates a mock Guzzle client that returns the given responses in order.
   *
   * @param \Psr\Http\Message\ResponseInterface[] $responses
   *   A queue of responses the client should return.
   *
   * @return \GuzzleHttp\ClientInterface
   *   A client configured with a mock handler for deterministic testing.
   */
  public static function fromResponses(array $responses): ClientInterface {
    $mock = new MockHandler($responses);
    $stack = HandlerStack::create($mock);
    return new Client(['handler' => $stack]);
  }

}
