/**
 * @file
 * Behavior to enable copy-to-clipboard functionality on share links.
 */

(function (Drupal, once) {
  Drupal.behaviors.copyLink = {
    attach(context, settings) {
      once('copy-link-init', '.copy-link', context).forEach((element) => {
        element.addEventListener('click', function (e) {
          e.preventDefault();
          const url = element.dataset.url || window.location.href;

          navigator.clipboard.writeText(url).then(() => {
            // Get element position relative to viewport
            const rect = element.getBoundingClientRect();
            const tooltip = document.createElement('span');
            tooltip.className = 'copy-tooltip global-tooltip';
            tooltip.innerText = Drupal.t('Copied!');

            // Set absolute position relative to viewport
            tooltip.style.position = 'fixed';
            tooltip.style.left = `${rect.left + rect.width / 2}px`;
            tooltip.style.top = `${rect.top - 40}px`;
            tooltip.style.transform = 'translateX(-50%)';
            tooltip.style.zIndex = 9999;

            document.body.appendChild(tooltip);

            // Fade out and remove
            setTimeout(() => {
              tooltip.classList.add('fade-out');
              setTimeout(() => tooltip.remove(), 500);
            }, 1500);
          }).catch((err) => {
            console.error('Clipboard copy failed: ', err);
          });

          // Accessibility: screen reader announcement.
          const srFeedback = document.getElementById('sr-copy-feedback');
          if (srFeedback) {
            srFeedback.textContent = Drupal.t('Copied!');
          }
        });
      });
    }
  };
})(Drupal, once);
