# DFD Export Features

This module now includes comprehensive export functionality for your Data Flow Diagrams (DFDs).

## Export Options

### 1. SVG Export
- **Button**: "Download as SVG" 
- **Format**: Vector SVG file
- **Usage**: Perfect for high-quality prints and further editing
- **Filename**: `dfd-diagram.svg`

### 2. PNG Export  
- **Button**: "Download as PNG"
- **Format**: High-resolution PNG image (2x scale factor)
- **Usage**: Great for presentations and documentation
- **Filename**: `dfd-diagram.png`
- **Background**: White background automatically added

### 3. Draw.io Export
- **Button**: "Open in Draw.io"
- **Format**: Draw.io compatible XML file
- **Usage**: Import directly into draw.io for further editing
- **Filename**: `dfd_diagram.xml`

## Features

### Color Coding in Draw.io Export:
- **Content Types (Nodes)**: Blue rectangles with rounded corners
- **Paragraphs**: Yellow rectangles with rounded corners  
- **Taxonomies**: Red diamond shapes
- **Relationships**: Arrows with field names as labels

### Smart Layout:
- Automatic positioning with 200px spacing
- Grid-based layout that wraps at 800px width
- Properly connected relationships between entities

### Technical Details:
- SVG export uses direct DOM serialization
- PNG export uses HTML5 Canvas with 2x scaling for clarity
- Draw.io XML follows the mxGraph format specification
- All exports maintain the same visual structure as the Mermaid diagram

## How to Use

1. Navigate to **Administration > Reports > Project DFD Analyzer**
2. Wait for the diagram to fully load
3. Click any of the export buttons:
   - **Download as PNG**: Downloads a high-quality PNG image
   - **Download as SVG**: Downloads a vector SVG file
   - **Open in Draw.io**: Downloads XML file that opens directly in draw.io

## Browser Compatibility

- **SVG Export**: All modern browsers
- **PNG Export**: All modern browsers (requires Canvas support)
- **Draw.io Export**: All browsers (downloads XML file)

## Import into Draw.io

1. Click "Open in Draw.io" button to download the XML file
2. Go to [draw.io](https://draw.io)
3. Click "Open Existing Diagram" or just drag and drop the file
4. Select the downloaded `.xml` file
5. Your DFD will load with full editability!

## Notes

- Export buttons are disabled until the Mermaid diagram fully renders
- PNG exports include a white background for better readability
- Draw.io format preserves all relationships and entity types
- The exported diagrams maintain the same color scheme and layout logic