# DrupalFit Module

Comprehensive security, performance, and best practices audit system for Drupal sites.

## Requirements

Drupal 10+

## Installation

Install as you would normally install a contributed Drupal module. See [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

Configure API authorization at `/admin/config/system/drupalfit-settings`.

## Usage

- **Report**: `/admin/reports/drupalfit-report`
- **API**: `/api/v1/drupalfit-report` (JSON format)
- **Help**: `/admin/reports/drupalfit-report/help`

## Scoring System

### How Scores Are Calculated

Each group starts at **100 points**. Points are deducted based on check severity:

| Severity | Penalty | Bonus |
|----------|---------|-------|
| Critical | -25     | -     |
| High     | -15     | -     |
| Medium   | -8      | -     |
| Low      | -3      | -     |
| Ok       | -       | +2    |
| Info     | 0       | 0     |

**Formula**: `Score = max(0, min(100, 100 - total_penalties))`

**Overall Score**: Calculated using one of two methods:

1. **Simple Average** (when no score weights defined):
   ```
   Overall Score = (Group1 Score + Group2 Score + ... + GroupN Score) / N
   ```

2. **Weighted Average** (when score weights are defined):
   ```
   Overall Score = (Group1 Score × Weight1 + Group2 Score × Weight2 + ...) / Total Weights
   ```

   Where weights are defined in each group's `scoreWeight` attribute (default: 10).

### Example

Security group with:
- 2 Critical issues: -50 points
- 1 High issue: -15 points
- 1 Medium issue: -8 points
- 1 Ok check: +2 points

**Score**: 100 - 50 - 15 - 8 + 2 = **29/100**

### Overall Score Example

With 3 groups:
- Security: 29/100 (weight: 20)
- Performance: 85/100 (weight: 15) 
- Best Practices: 92/100 (weight: 10)

**Simple Average**: (29 + 85 + 92) / 3 = **68.7/100**

**Weighted Average**: (29×20 + 85×15 + 92×10) / (20+15+10) = (580 + 1275 + 920) / 45 = **61.7/100**

## Architecture

### Core Components

- **FitCheckPluginManager**: Discovers and manages check plugins
- **FitCheckGroupPluginManager**: Manages check groups
- **FitReportCollector**: Executes checks and collects results
- **FitScoreCalculator**: Calculates scores from results
- **FitResultGrouper**: Groups results by severity for display

### Data Flow

1. Controller calls `FitReportCollector::generate()`
2. Collector executes all check plugins
3. Results stored in `FitResultCollection`
4. `FitScoreCalculator` calculates scores
5. `FitResultGrouper` prepares data for template
6. Template renders report with scores

## Developer Guide

### Creating a New Check

1. Create a new class in `src/Plugin/FitCheck/`
2. Extend `FitCheckPluginBase`
3. Add `#[FitCheck()]` attribute with id, fitGroup, label, description, messages
4. Implement `execute()` method that returns `FitResult`
5. Set appropriate `FitWeight` based on check result
6. Add success/failure messages and help text

### Creating a New Group

1. Create a new class in `src/Plugin/FitCheckGroup/`
2. Extend `FitCheckGroupPluginBase`
3. Add `#[FitCheckGroup()]` attribute with id, label, weight, scoreWeight
4. Define `GROUP_ID` constant for use in checks

### Group Attributes

- **id**: Unique identifier
- **label**: Display name
- **weight**: Display order (lower = first)
- **scoreWeight**: Weight in overall score calculation
- **externalProvider**: TRUE if handled by external system

### Check Attributes

- **id**: Unique identifier
- **fitGroup**: Group ID (use `GroupClass::GROUP_ID`)
- **label**: Check name
- **description**: What the check does
- **successMessage**: Message when check passes
- **failureMessage**: Message when check fails

### Severity Levels

**Critical**: Immediate action required
- Exposed credentials
- Active UID 1 account
- Missing security updates

**High**: Significant security/performance issue
- Dangerous permissions
- Development modules in production
- No caching enabled

**Medium**: Moderate issue
- Weak passwords
- Outdated modules
- Unoptimized assets

**Low**: Minor issue
- Inactive users
- Minor config improvements

**Ok**: Check passed
- Properly configured
- Best practices followed

**Info**: Informational only (no score impact)

### Help Messages

Use `setHelpRenderArray()` with render arrays for rich help content including links and formatted text.

## Constants

Centralized in `DrupalFitConstants`:
- `MAX_SCORE`: 100
- `MIN_SCORE`: 0
- `EXTERNAL_PROVIDER_URL`: External report URL

## External Providers

Groups can be marked as handled by external systems by setting `externalProvider: TRUE` in the attribute.

This displays:
- DrupalFit logo in group header
- "View" button linking to external report

## Testing

- Clear cache after adding/modifying checks: `drush cr`
- Verify check execution via Drush using `drupalfit.report_collector` service
- Check scores via report interface at `/admin/reports/drupalfit-report`
