<?php

declare(strict_types=1);

namespace Drupal\drupalfit;

use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Interface for fit_check_group plugins.
 */
interface FitCheckGroupInterface {

  /**
   * Returns the translated plugin label.
   */
  public function label(): string;

  /**
   * Get the description.
   */
  public function description(): ?TranslatableMarkup;

  /**
   * Get the group weight.
   */
  public function weight(): int|float;

}
