<?php

declare(strict_types=1);

namespace Drupal\drupalfit;

/**
 * Represents the complete scoring result.
 */
class FitScoreResult {

  public function __construct(
    public GroupScoreCollection $groups,
    public Score $overall,
  ) {}

  /**
   * Gets the group scores.
   */
  public function getGroups(): GroupScoreCollection {
    return $this->groups;
  }

  /**
   * Gets the overall score.
   */
  public function getOverall(): Score {
    return $this->overall;
  }

  /**
   * Converts to array.
   */
  public function toArray(): array {
    return [
      'overall' => $this->overall->toArray(),
      'groups' => $this->groups->toArray(),
    ];
  }

}
