<?php

declare(strict_types=1);

namespace Drupal\drupalfit\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides configuration form for Drupalfit settings.
 */
class DrupalfitConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['drupalfit.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'drupalfit_setting_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('drupalfit.settings');
    $form['settings'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('API Configuration'),
      '#description' => $this->t('Configure API settings to enable enhanced monitoring and reporting features.'),
    ];
    $form['settings']['api_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('API Key'),
      '#default_value' => $config->get('api_key'),
      '#description' => $this->t('Enter your API key. You can obtain this from your account dashboard.'),
      '#maxlength' => 255,
    ];
    $form['settings']['domain'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Domain'),
      '#default_value' => $config->get('domain') ?: \Drupal::request()->getHost(),
      '#description' => $this->t('Enter your site domain (e.g., example.com).'),
      '#maxlength' => 255,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $config = $this->config('drupalfit.settings');
    $config
      ->set('api_key', $form_state->getValue('api_key'))
      ->set('domain', $form_state->getValue('domain'))
      ->save();
    $this->messenger()->addStatus($this->t('Configuration saved.'));
    parent::submitForm($form, $form_state);
  }

}
