<?php

declare(strict_types=1);

namespace Drupal\drupalfit\Plugin\FitCheckGroup;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\drupalfit\Attribute\FitCheckGroup;
use Drupal\drupalfit\FitCheckGroupPluginBase;

/**
 * Accessibility checks group.
 */
#[FitCheckGroup(
  id: self::GROUP_ID,
  weight: -100,
  scoreWeight: 10,
  label: new TranslatableMarkup('Accessibility'),
  description: new TranslatableMarkup('WCAG compliance and accessibility checks.'),
  externalProvider: TRUE,
)]
final class AccessibilityGroup extends FitCheckGroupPluginBase {

  public const string GROUP_ID = 'accessibility';

}
