<?php

declare(strict_types=1);

namespace Drupal\drupalfit\Plugin\FitCheckGroup;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\drupalfit\Attribute\FitCheckGroup;
use Drupal\drupalfit\FitCheckGroupPluginBase;

/**
 * Content and configuration checks group.
 */
#[FitCheckGroup(
  id: self::GROUP_ID,
  weight: 0,
  scoreWeight: 10,
  label: new TranslatableMarkup('Content & Config'),
  description: new TranslatableMarkup('Content quality and configuration settings.'),
)]
final class ContentAndConfigGroup extends FitCheckGroupPluginBase {

  public const string GROUP_ID = 'content_and_config';

}
