<?php

declare(strict_types=1);

namespace Drupal\drupalfit\Plugin\FitCheckGroup;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\drupalfit\Attribute\FitCheckGroup;
use Drupal\drupalfit\FitCheckGroupPluginBase;

/**
 * Security checks group.
 */
#[FitCheckGroup(
  id: self::GROUP_ID,
  weight: -80,
  scoreWeight: 30,
  label: new TranslatableMarkup('Security'),
  description: new TranslatableMarkup('Security vulnerabilities and hardening checks.'),
)]
final class SecurityGroup extends FitCheckGroupPluginBase {

  public const string GROUP_ID = 'security';

}
