<?php

declare(strict_types=1);

namespace Drupal\drupalfit\Plugin\FitCheckGroup;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\drupalfit\Attribute\FitCheckGroup;
use Drupal\drupalfit\FitCheckGroupPluginBase;

/**
 * SEO checks group.
 */
#[FitCheckGroup(
  id: self::GROUP_ID,
  weight: -90,
  scoreWeight: 15,
  label: new TranslatableMarkup('SEO/GEO'),
  description: new TranslatableMarkup('Search engine optimization and discoverability checks.'),
  externalProvider: TRUE
)]
final class SeoGroup extends FitCheckGroupPluginBase {

  public const string GROUP_ID = 'seo';

}
