<?php

declare(strict_types=1);

namespace Drupal\drupalfit\Attribute;

use Drupal\Component\Plugin\Attribute\AttributeBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * The fit_check_group attribute.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
final class FitCheckGroup extends AttributeBase {

  /**
   * Constructs a new FitCheckGroup instance.
   *
   * @param string $id
   *   The plugin ID. There are some implementation bugs that make the plugin
   *   available only if the ID follows a specific pattern. It must be either
   *   identical to group or prefixed with the group. E.g. if the group is "foo"
   *   the ID must be either "foo" or "foo:bar".
   * @param int|float $weight
   *   Display order weight (negative = displayed first).
   * @param int $scoreWeight
   *   Score importance weight (default: 10). Higher = more impact on overall score.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   (optional) The human-readable name of the plugin.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   (optional) A brief description of the plugin.
   * @param bool $externalProvider
   *   (optional) TRUE if handled by external DrupalFit application.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    string $id,
    public readonly int|float $weight,
    public readonly int $scoreWeight = 10,
    public readonly ?TranslatableMarkup $label = NULL,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly bool $externalProvider = FALSE,
    public readonly ?string $deriver = NULL,
  ) {
    parent::__construct($id);
  }

}
