<?php

declare(strict_types=1);

namespace Drupal\drupalfit;

/**
 * Data transfer object for audit scores.
 */
final class AuditScores {

  /**
   * Constructs AuditScores.
   */
  public function __construct(
    public ?int $accessibility = NULL,
    public ?int $seo = NULL,
    public ?int $performance = NULL,
  ) {}

  /**
   * Creates from API response array.
   */
  public static function fromArray(array $data): self {
    return new self(
      accessibility: isset($data['accessibilityScore']) ? (int) $data['accessibilityScore'] : NULL,
      seo: isset($data['seoScore']) ? (int) $data['seoScore'] : NULL,
      performance: isset($data['performanceScore']) ? (int) $data['performanceScore'] : NULL,
    );
  }

  /**
   *
   */
  public function getAccessibility(): ?int {
    return $this->accessibility;
  }

  /**
   * Gets the SEO score.
   *
   * @return int|null
   *   The SEO score as an integer, or NULL if not set.
   */
  public function getSeo(): ?int {
    return $this->seo;
  }

  /**
   * Gets the performance score.
   *
   * @return int|null
   *   The performance score as an integer, or NULL if not set.
   */
  public function getPerformance(): ?int {
    return $this->performance;
  }

}
