<?php

declare(strict_types=1);

namespace Drupal\drupalfit\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\drupalfit\Service\FitReportCollectorInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Returns responses for Drupalfit API routes.
 */
final class DrupalFitResourceApi extends ControllerBase {

  /**
   * The controller constructor.
   */
  public function __construct(
    private readonly FitReportCollectorInterface $drupalfitReportCollector,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): self {
    return new self(
      $container->get('drupalfit.report_collector'),
    );
  }

  /**
   * Builds the response.
   */
  public function __invoke(): JsonResponse {
    $results = $this->drupalfitReportCollector->generate();
    $scores = $this->drupalfitReportCollector->calculateScore($results)->calculateScores();

    return new JsonResponse([
      'scores' => $scores->toArray(),
      'results' => array_map(static fn($r) => [
        'id' => $r->id(),
        'name' => $r->name(),
        'group' => $r->group(),
        'weight' => $r->weight()->name,
        'description' => (string) $r->getDescription(),
        'success_message' => (string) $r->getSuccessMessage(),
        'failure_message' => (string) $r->getFailureMessage(),
        'warning_message' => (string) $r->getWarningMessage(),
        'error_message' => (string) $r->getErrorMessage(),
        'info_message' => (string) $r->getInfoMessage(),
      ], $results->getAll()),
    ]);
  }

}
