<?php

declare(strict_types=1);

namespace Drupal\drupalfit;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\drupalfit\Attribute\FitCheckGroup;

/**
 * FitCheckGroup plugin manager.
 */
final class FitCheckGroupPluginManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/FitCheckGroup', $namespaces, $module_handler, FitCheckGroupInterface::class, FitCheckGroup::class);
    $this->alterInfo('fit_check_group_info');
    $this->setCacheBackend($cache_backend, 'fit_check_group_plugins');
  }

}
