<?php

namespace Drupal\drupalfit;

/**
 * Represents a group score.
 */
class GroupScore {

  public function __construct(public string $group, public int $score, public int $percentage, public bool $externalProvider = FALSE) {}

  /**
   * Gets the group.
   */
  public function getGroup(): string {
    return $this->group;
  }

  /**
   * Gets the score.
   */
  public function getScore(): int {
    return $this->score;
  }

  /**
   * Gets the percentage.
   */
  public function getPercentage(): int {
    return $this->percentage;
  }

  /**
   * Checks if external provider.
   */
  public function isExternalProvider(): bool {
    return $this->externalProvider;
  }

  /**
   * Converts to array.
   */
  public function toArray(): array {
    return [
      'group' => $this->group,
      'score' => $this->score,
      'percentage' => $this->percentage,
      'external_provider' => $this->externalProvider,
    ];
  }

}
