<?php

namespace Drupal\drupalfit;

/**
 * Represents a collection of group scores and percentage information.
 */
class GroupScoreCollection implements \Iterator, \Countable {

  /**
   * Array of group scores.
   *
   * @var \Drupal\drupalfit\GroupScore[]
   */
  public array $scores = [];

  /**
   * Current position for iterator.
   *
   * @var int
   */
  private int $position = 0;

  /**
   * Adds a score.
   */
  public function addScore(GroupScore $score): void {
    $this->scores[] = $score;
  }

  /**
   * Gets all scores.
   */
  public function getScores(): array {
    return $this->scores;
  }

  /**
   * {@inheritdoc}
   */
  public function count(): int {
    return count($this->scores);
  }

  /**
   * Clears all scores.
   */
  public function clear(): void {
    $this->scores = [];
  }

  /**
   * Converts to array.
   */
  public function toArray(): array {
    $data = [];
    foreach ($this->scores as $score) {
      $data[] = $score->toArray();
    }
    return $data;
  }

  /**
   * {@inheritdoc}
   */
  public function current(): mixed {
    return $this->scores[$this->position];
  }

  /**
   * {@inheritdoc}
   */
  public function next(): void {
    $this->position++;
  }

  /**
   * {@inheritdoc}
   */
  public function key(): int {
    return $this->position;
  }

  /**
   * {@inheritdoc}
   */
  public function valid(): bool {
    return isset($this->scores[$this->position]);
  }

  /**
   * {@inheritdoc}
   */
  public function rewind(): void {
    $this->position = 0;
  }

}
