# DrupalFit Module

Comprehensive Drupal site audit platform delivering continuous security monitoring, accessibility checks, and performance optimization to keep sites secure, compliant, and fast.

## Requirements

- Drupal 10.2 or higher

## Installation

Install via Composer:

```bash
composer require drupal/drupalfit
```

## Getting Started

### Step 1: Access the Module

Navigate to **Reports > DrupalFit Report** (`/admin/reports/drupalfit-report`)

### Step 2: View Analysis Report

The **Analysis Report** tab shows your site's security, performance, and best practices audit results with:
- Overall site score (0-100)
- Group scores for Security, Performance, Best Practices, SEO, and Accessibility
- Detailed findings with severity levels
- Actionable recommendations

### Step 3: Connect to DrupalFit (Optional)

For advanced accessibility and SEO reports:

1. Register at [DrupalFit.com](https://drupalfit.com/register)
2. Generate an API key from the "Drupal Status Report" tab
3. Go to **Settings** tab in the module
4. Enter your API key and domain
5. Access enhanced reports in the **DrupalFit** tab

## Features

### Analysis Report

- **Security Checks**: Identifies vulnerabilities, exposed credentials, dangerous permissions
- **Performance Monitoring**: Caching, aggregation, database optimization
- **Best Practices**: Configuration recommendations, module updates
- **Content & Config**: Entity definitions, pending updates
- **SEO/GEO**: Search engine optimization (via DrupalFit)
- **Accessibility**: WCAG compliance checks (via DrupalFit)

## Permissions

Configure user access at **People > Permissions**:

- **View DrupalFit reports**: Access and view audit reports
- **Administer DrupalFit**: Configure settings and API keys

## Configuration

### Settings

Navigate to **Reports > DrupalFit Report > Settings** to configure:

- **API Key**: Your DrupalFit API key for enhanced reports
- **Domain**: Your site domain (auto-populated)

## Support

- **Documentation**: Visit the **Help** tab in the module
- **Issues**: Report bugs or request features on the project page
- **DrupalFit Platform**: [https://drupalfit.com](https://drupalfit.com)

## License

GPL-2.0-or-later
