<?php

declare(strict_types=1);

namespace Drupal\drupalfit;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Base class for fit_check_group plugins.
 */
abstract class FitCheckGroupPluginBase extends PluginBase implements FitCheckGroupInterface {

  /**
   * {@inheritdoc}
   */
  public function label(): string {
    return (string) $this->pluginDefinition['label'];
  }

  /**
   * {@inheritDoc}
   */
  public function description(): ?TranslatableMarkup {
    return $this->pluginDefinition['description'];
  }

  /**
   * {@inheritDoc}
   */
  public function weight(): int|float {
    return $this->pluginDefinition['weight'];
  }

}
