<?php

declare(strict_types=1);

namespace Drupal\drupalfit;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Base class for fit_check plugins.
 */
abstract class FitCheckPluginBase extends PluginBase implements FitCheckInterface, ContainerFactoryPluginInterface {
  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function label(): string {
    return (string) $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function description(): ?TranslatableMarkup {
    return $this->pluginDefinition['description'] ?? NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function successMessage(): ?TranslatableMarkup {
    return $this->pluginDefinition['successMessage'] ?? NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function fitGroup(): string {
    return $this->pluginDefinition['fitGroup'];
  }

  /**
   * {@inheritdoc}
   */
  public function failureMessage(): ?TranslatableMarkup {
    return $this->pluginDefinition['failureMessage'] ?? NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function warningMessage(): ?TranslatableMarkup {
    return $this->pluginDefinition['warningMessage'] ?? NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function errorMessage(): ?TranslatableMarkup {
    return $this->pluginDefinition['errorMessage'] ?? NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function infoMessage(): ?TranslatableMarkup {
    return $this->pluginDefinition['infoMessage'] ?? NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function helpMessage(): array {
    return $this->pluginDefinition['helpMessage'] ?? [];
  }

}
