<?php

declare(strict_types=1);

namespace Drupal\drupalfit;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\drupalfit\Attribute\FitCheck;

/**
 * FitCheck plugin manager.
 */
final class FitCheckPluginManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/FitCheck', $namespaces, $module_handler, FitCheckInterface::class, FitCheck::class);
    $this->alterInfo('fit_check_info');
    $this->setCacheBackend($cache_backend, 'fit_check_plugins');
  }

}
