<?php

declare(strict_types=1);

namespace Drupal\drupalfit\Plugin\FitCheckGroup;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\drupalfit\Attribute\FitCheckGroup;
use Drupal\drupalfit\FitCheckGroupPluginBase;

/**
 * Best practices checks group.
 */
#[FitCheckGroup(
  id: self::GROUP_ID,
  weight: -60,
  scoreWeight: 15,
  label: new TranslatableMarkup('Best Practices'),
  description: new TranslatableMarkup('Configuration and coding best practices.'),
)]
final class BestPracticesGroup extends FitCheckGroupPluginBase {

  public const  GROUP_ID = 'best_practices';

}
