<?php

declare(strict_types=1);

namespace Drupal\drupalfit\Plugin\FitCheckGroup;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\drupalfit\Attribute\FitCheckGroup;
use Drupal\drupalfit\FitCheckGroupPluginBase;

/**
 * Performance checks group.
 */
#[FitCheckGroup(
  id: self::GROUP_ID,
  weight: -70,
  scoreWeight: 20,
  label: new TranslatableMarkup('Performance'),
  description: new TranslatableMarkup('Site speed, caching, and optimization checks.'),
)]
final class PerformanceGroup extends FitCheckGroupPluginBase {

  public const GROUP_ID = 'performance';

}
