<?php

declare(strict_types=1);

namespace Drupal\drupalfit;

/**
 * Represents a score value.
 */
class Score {

  public function __construct(public int $score, public int $percentage) {}

  /**
   * Gets the score.
   */
  public function getScore(): int {
    return $this->score;
  }

  /**
   * Gets the percentage.
   */
  public function getPercentage(): int {
    return $this->percentage;
  }

  /**
   * Converts to array.
   */
  public function toArray(): array {
    return [
      'score' => $this->getScore(),
      'percentage' => $this->getPercentage(),
    ];
  }

}
