<?php

declare(strict_types=1);

namespace Drupal\drupalfit\Service;

use Drupal\drupalfit\FitResultCollection;
use Drupal\drupalfit\FitScoreCalculator;

/**
 * Interface for collecting and generating Drupal Fit reports.
 */
interface FitReportCollectorInterface {

  /**
   * Generate the reports and collect the check result.
   *
   * Runs all configured Drupal Fit checks and collects their results into
   * a single collection object.
   *
   * @return \Drupal\drupalfit\FitResultCollection
   *   A collection containing the results of all executed checks.
   */
  public function generate(): FitResultCollection;

  /**
   * Calculates fit score based on check results and group weights.
   *
   * @param \Drupal\drupalfit\FitResultCollection $collection
   *   Collection of fit check results.
   *
   * @return \Drupal\drupalfit\FitScoreCalculator
   *   Calculator with weighted scores.
   */
  public function calculateScore(FitResultCollection $collection): FitScoreCalculator;

}
