<?php

declare(strict_types=1);

namespace Drupal\drupical\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hook implementations for drupical.
 */
class EventsFeedHooks {

  /**
   * Implements hook_theme().
   */
  #[Hook('theme')]
  public function theme($existing, $type, $theme, $path): array {
    return [
      'drupical' => [
        'variables' => [
          'featured' => [],
          'standard' => [],
          'count' => 0,
          'total_count' => 0,
          'has_more' => FALSE,
          'offset' => 0,
          'limit' => 5,
          'organize_link' => '',
          'drupalcon_link' => '',
          'camps_link' => '',
          'drupical_link' => '',
          'add_event_link' => '',
        ],
      ],
      'drupical_item' => [
        'variables' => [
          'event' => NULL,
          'featured' => FALSE,
        ],
      ],
    ];
  }

  /**
   * Implements hook_cron().
   */
  #[Hook('cron')]
  public function cron(): void {
    $config = \Drupal::config('drupical.settings');
    $interval = $config->get('cron_interval') ?? 3600;
    $last_check = \Drupal::state()->get('drupical.last_fetch', 0);
    $time = \Drupal::time()->getRequestTime();
    if ($time - $last_check > $interval) {
      \Drupal::service('drupical.fetcher')->fetch(TRUE);
      \Drupal::state()->set('drupical.last_fetch', $time);
    }
  }

}
