Introduction
============

The Drupitor Client module provides a secure API endpoint to check for available Composer package updates in your Drupal installation. This module is designed for integration with external monitoring services while maintaining strict security controls.

Requirements
============

* Drupal 10+
* Composer-based Drupal installation
* PHP proc_open() function available
* Composer executable accessible on the system

Installation
============

1. Install the module via Composer or manually:
   - Via Composer: `composer require drupal/drupitor_client`
   - Manually: Download from the project page and place in your sites modules directory.
2. Enable the module using Drush or via the UI:
   - Via Drush: `drush en drupitor_client`
   - Via UI: Navigate to Administration > Extend and enable "Drupitor Client"
3. Configure the module at Administration > Configuration > Development > Drupitor Client

Configuration
=============

**Configure via UI**<br>
After installation, navigate to Administration > Configuration > Development > Drupitor Client to configure:

* Enable/Disable: Control whether the API endpoint is accessible
* Composer Path: Specify the absolute path to your Composer executable
* Command Timeout: Set timeout for Composer commands (10-300 seconds)

The module starts in a disabled state for security and must be explicitly enabled.

**Configure via settings.php**<br>
You can also manage the configuration via settings.php:

<code>
$config['drupitor_client.settings']['enabled'] = TRUE;
$config['drupitor_client.settings']['api_token'] = '[YOUR_API_TOKEN]';
$config['drupitor_client.settings']['encryption_key'] = '[YOUR_ENCRYPT_KEY]';
$config['drupitor_client.settings']['encryption_method'] = 'AES-256-GCM';
$config['drupitor_client.settings']['composer_path'] = 'composer';
$config['drupitor_client.settings']['command_timeout'] = '60';
</code>

API usage
=========

When enabled, the module provides a JSON endpoint at: /drupitor/api/v1/updates

The endpoint is only accessible when:
* The module itself is enabled, and it's functionality is enabled on the configuration page
* The correct API token (configured on the configuration page) is provided in the request header (recommended) or as a query parameter (not recommended for security reasons)

Logging
-------
All operations are logged to the 'drupitor_client' channel for security auditing and troubleshooting.