<?php

namespace Drupal\drush_extra\Drush\Commands\Cron;

use Consolidation\AnnotatedCommand\CommandData;
use Consolidation\AnnotatedCommand\Hooks\HookManager;
use Drupal\Core\Lock\LockBackendInterface;
use Drupal\drush_extra\Services\CommandInfoService;
use Drush\Attributes as CLI;
use Drush\Boot\DrupalBootLevels;
use Drush\Commands\AutowireTrait;
use Drush\Commands\DrushCommands;
use Drush\Drush;
use Symfony\Component\DependencyInjection\Attribute\Autowire;

/**
 * Drush command to release the cron system lock.
 */
class ReleaseCommand extends DrushCommands {

  use AutowireTrait;

  const COMMAND = 'core:cron:release';
  const ALIASES = ['cror', 'cron:release', 'cron-release'];

  public function __construct(
    #[Autowire(service: 'lock')]
    private readonly LockBackendInterface $lock,
  ) {
    parent::__construct();
  }

  /**
   * Release cron system lock to run cron again.
   */
  #[CLI\Command(name: self::COMMAND, aliases: self::ALIASES)]
  #[CLI\Usage(name: 'drush core:cron:release')]
  #[CLI\Bootstrap(level: DrupalBootLevels::FULL)]
  public function release() {
    try {
      $this->lock->release('cron');
      $this->io()->success(
        dt('Cron lock was released successfully')
      );
    }
    catch (\Exception $e) {
      $this->io()->error($e->getMessage());
    }

    Drush::drush(Drush::aliasManager()->getSelf(), 'cache:rebuild')->run();
  }

  /**
   * Displays the command description before executing the command.
   */
  #[CLI\Hook(type: HookManager::PRE_COMMAND_HOOK, target: self::COMMAND)]
  public function preCommand(CommandData $commandData) {
    $commandHelper = new CommandInfoService($commandData);

    $this->io()->text(
      $commandHelper->getCommandDescription()
    );
  }

}
