<?php

namespace Drupal\drush_extra\Services;

use Consolidation\AnnotatedCommand\CommandData;
use Drush\Drush;
use Symfony\Component\Console\Command\Command;

/**
 * Helper class for Drush commands.
 */
class CommandInfoService {
  /**
   * The command data instance.
   *
   * @var \Consolidation\AnnotatedCommand\CommandData
   */
  protected $commandData;

  /**
   * The Drush application instance.
   *
   * @var \Symfony\Component\Console\Application
   */
  protected $application;

  public function __construct(CommandData $commandData) {
    $this->commandData = $commandData;
    $this->application = Drush::getApplication();
  }

  /**
   * Returns the command name.
   */
  public function getCommandDescription(): string {
    return $this->getCommand()->getDescription();
  }

  /**
   * Returns the command.
   */
  protected function getCommand(): Command {
    return $this->application->get($this->getCommandName());
  }

  /**
   * Returns the command name.
   */
  protected function getCommandName(): string {
    return $this->commandData->annotationData()->get('command');
  }

}
