<?php

namespace Drupal\Tests\drush_extra\Functional\Drush\Commands\Cron;

use Drupal\drush_extra\Drush\Commands\Cron\ReleaseCommand;
use Drupal\Tests\BrowserTestBase;
use Drush\TestTraits\DrushTestTrait;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;

/**
 * Tests the Drush command for releasing the cron system lock.
 */
#[CoversClass(ReleaseCommand::class)]
#[Group('drush_extra')]
class ReleaseCommandTest extends BrowserTestBase {

  use DrushTestTrait;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'drush_extra',
  ];

  /**
   * Tests the cron release command.
   */
  public function testReleaseCommand() {
    $this->drush('core:cron:release');
    $output = $this->getOutput();
    $this->assertStringContainsString('Cron lock was released successfully', $output);
  }

}
