<?php

namespace Drupal\Tests\drush_extra\Functional\Drush\Commands\Debug;

use Drupal\drush_extra\Drush\Commands\Debug\EntityCommand;
use Drupal\Tests\BrowserTestBase;
use Drush\TestTraits\DrushTestTrait;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;

/**
 * Tests the Drush command for displaying entity information.
 */
#[CoversClass(EntityCommand::class)]
#[Group('drush_extra')]
class EntityCommandTest extends BrowserTestBase {

  use DrushTestTrait;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'node',
    'system',
    'drush_extra',
  ];

  /**
   * Tests the debug:entity command.
   */
  public function testEntityCommand() {
    $this->drush('debug:entity');
    $output = $this->getOutput();
    $this->assertStringContainsString('Entity class ID', $output);
    $this->assertStringContainsString('Entity ID', $output);
    $this->assertStringContainsString('Entity label', $output);
    $this->assertStringContainsString('Entity group', $output);

    // Test for the node bundle in the Content group.
    $this->drush('debug:entity', ['Content']);
    $output = $this->getOutput();
    $this->assertStringContainsString('node', $output);
  }

}
