<?php

namespace Drupal\Tests\drush_extra\Functional\Drush\Commands\Debug;

use Drupal\drush_extra\Drush\Commands\Debug\ImageStylesCommand;
use Drupal\Tests\BrowserTestBase;
use Drush\TestTraits\DrushTestTrait;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;

/**
 * Tests the Drush command for displaying image styles and their effects.
 */
#[CoversClass(ImageStylesCommand::class)]
#[Group('drush_extra')]
class ImageStylesCommandTest extends BrowserTestBase {

  use DrushTestTrait;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'image',
    'system',
    'drush_extra',
  ];

  /**
   * Tests the debug:image:styles command.
   */
  public function testImageStylesCommand() {
    $this->drush('debug:image:styles');
    $output = $this->getOutput();
    $this->assertStringContainsString('Machine Name', $output);
    $this->assertStringContainsString('Label', $output);
    $this->assertStringContainsString('Effects', $output);

    // Check for some default image styles.
    $this->assertTrue(
      str_contains($output, 'thumbnail') || str_contains($output, 'medium') || str_contains($output, 'large'),
      'Output contains at least one default image style (thumbnail, medium, or large)'
    );
  }

}
